/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.quests;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.common.quests.condition.QuestConditionLoader;
import dev.toma.gunsrpg.common.quests.condition.list.QuestConditionListManager;
import dev.toma.gunsrpg.common.quests.quest.QuestManager;
import dev.toma.gunsrpg.common.quests.reward.QuestRewardManager;
import dev.toma.gunsrpg.util.ILogHandler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraftforge.event.AddReloadListenerEvent;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class QuestSystem {
    public static final Marker MARKER = MarkerManager.getMarker((String)"Quests");
    private final ILogHandler logger = ILogHandler.wrapLoggerWithMarker(GunsRPG.log, MARKER);
    private final QuestRewardManager rewardManager = new QuestRewardManager(this.logger);
    private final QuestConditionLoader conditionLoader = new QuestConditionLoader();
    private final QuestConditionListManager conditionListManager = new QuestConditionListManager(this.logger, this.conditionLoader);
    private final QuestManager questManager = new QuestManager(this.logger, this.conditionLoader);

    public QuestRewardManager getRewardManager() {
        return this.rewardManager;
    }

    public QuestConditionLoader getConditionLoader() {
        return this.conditionLoader;
    }

    public QuestConditionListManager getConditionListManager() {
        return this.conditionListManager;
    }

    public QuestManager getQuestManager() {
        return this.questManager;
    }

    public void initialize(AddReloadListenerEvent event) {
        this.logger.info("Starting up quest system", new Object[0]);
        event.addListener((IFutureReloadListener)this.rewardManager);
        event.addListener((IFutureReloadListener)this.conditionListManager);
        event.addListener((IFutureReloadListener)this.questManager);
    }
}

